/*------------------------------------------------------------------------------*
 * File Name: XFWizDlg.c	 													*
 * Creation: Sim 03-20-2007														*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Sim 08-19-2008 QA80-12050 GET_GUI_GETN_TREE_FOR_CHANGE_PARAM_MODE			*
 *	Sim 08-21-2008 QA80-12054 CANCEL_HANDLER_ALREADY_DESTROY_WINDOW				*
 *	Sim 08-21-2008 QA80-12054 CAN_NOT_DELETE_OWN_OBJECT_ON_BASE_CLASS			*
 *	Sim 11-10-2008 FIX_DEFAULT_SHOW_ALL_PA_XFS									*
 *	Folger 11/13/08 QA80-12488 v8.970 PROPER_HANDING_ABOUT_WIZARD_OPERATION_EXECUTE_HELPER
 *	Sim 12-09-2008 QA80-12741 OPERATION_UNPROTECT_IO_RANGE_IN_EXEC_TIME_OF_CHANGE_PARAM_FUNC
 *	Folger 12/10/08 v8.0984d REMOVE_ANALYSIS_MARKER_WHEN_CLICK_CANCEL_IN_WIZARD	*
 *	Sim 12-12-2008 QA80-12764-P3 PA_MODAL_DIALOG_ALSO_FORCE_SET_SHOW_FLAG_AS_ON_PAGE_CHANGE_EVENT_NEED_IT
 *	Sophy 12/18/2008 v8.0988 QA80-12798 CHANGE_PARAMETERS_SHOULD_SHOW_THEME_MENU*
 *	Sim 12-29-2008 QA80-12798 XF_WIZ_THEME_COMPARE								*
 *	Sim 01-08-2008 QA80-12900 FIX_NOT_AUTO_CLEAR_FOR_XF_WIZ						*
 *	Hong 02/01/09 HIDE_THEME_CONTROL_IN_CHANGE_PARAMS_DLG_IN_SR5				*
 *	Hong 09/24/09 QA80-14350 NLFIT_DLG_NEED_HINT_TO_GUIDE_USER_MAKE_IT_MODALLESS*
 *	Folger 11/03/09 BETTER_CHECKING_FOR_RUNNING_PA_FROM_AUTO_UPDATE				*
 *	Sim 01-07-2009 QA81-14898 SHOW_GUI_SETTINGS_FOR_XFWIZ_OPERATION				*
 *	Jasmine 04/14/10 QA81-15304 ANNOUNCE_FITTING_FUNC_CHANGE					*
 *	Folger 10/25/2010 ORG-1279 DIALOG_DISPLAY_NOT_GOOD_IN_CHINESE				*
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
// Including the system header file Origin.h should be sufficient for most Origin
// applications and is recommended. Origin.h includes many of the most common system
// header files and is automatically pre-compiled when Origin runs the first time.
// Programs including Origin.h subsequently compile much more quickly as long as
// the size and number of other included header files is minimized. All NAG header
// files are now included in Origin.h and no longer need be separately included.
//
// Right-click on the line below and select 'Open "Origin.h"' to open the Origin.h
// system header file.
#include <Origin.h>
////////////////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////////////////
// Include your own header files here.
#include <xfutils.h>

#include <..\OriginLab\WizOperation.h>
#include <..\OriginLab\XFWizDlg.h>
#include <..\OriginLab\pa_utils.h>	///Jasmine 04/14/10 QA81-15304 ANNOUNCE_FITTING_FUNC_CHANGE

#define XF_WIZ_DIALOG_MODE	LTXF_XFBAR|LTXF_SHOW_DIALOG|LTXF_USE_FAST_ACCESS
////////////////////////////////////////////////////////////////////////////////////
// Start your functions here.
XFWizRunModelDlg::XFWizRunModelDlg(HWND hDlg, WizardControl *pWizCtrl)
: XFWizRunModelBase()
{
	m_stXFMode.nXFType = XF_GETN_SIMPLE;
	m_stXFMode.dwXFMode = XF_WIZ_DIALOG_MODE;
	m_stXFMode.dwExecute = LTXF_EXECUTE;
	m_stXFMode.nAddRecalculate = XFGETN_EX_NONE;
	m_stXFMode.nAddResultsLogOutput = XFGETN_EX_NONE;
	
	m_hDlg = hDlg;
	m_pXFWizCtrl = pWizCtrl;
}

DWORD XFWizRunModelDlg::SendDlgMsg(DWORD msg, DWORD wParam, DWORD lParam) // = 0, 0
{
	Window wnd(m_hDlg);
	if ( wnd )
		return wnd.SendMessage(msg, wParam, lParam);
	return 0;
}
DWORD XFWizRunModelDlg::PostDlgMsg(DWORD msg, DWORD wParam, DWORD lParam) // = 0, 0
{
	Window wnd(m_hDlg);
	if ( wnd )
		return wnd.PostMessage(msg, wParam, lParam);
	return 0;
}

//void XFWizRunModelDlg::SetMapStepLabels(const StringArray& saMapXFNames, const StringArray& saMapXFLabels)
//{
	//m_saMapXFNames = saMapXFNames;
	//m_saMapXFLabels = saMapXFLabels;
//}
//virtual
//bool XFWizRunModelDlg::UpdateSteps(const StringArray &saXFNames)
bool XFWizRunModelDlg::UpdateSteps(const StringArray &saSteps)
{
	/*
	StringArray saXFLabels;
	if ( !GetStepLabels(saXFNames, saXFLabels) )
		return false;
	if ( saXFNames.GetSize() != saXFLabels.GetSize() ) 
	{
		ASSERT(FALSE);
		return false;
	}
	*/
	StringArray saXFLabels;
	saXFLabels = saSteps;	
	
	int ii;
	int nSizeSteps = saXFLabels.GetSize();
	int nSizeStepsInCtrl = m_pXFWizCtrl->GetNumSteps();
	
	if ( nSizeSteps < nSizeStepsInCtrl )
	{
		// can't remove the redundant steps, so only hide them
		for ( ii = nSizeSteps; ii < nSizeStepsInCtrl; ii++ )
			m_pXFWizCtrl->ShowStep(ii, FALSE);
		nSizeStepsInCtrl = nSizeSteps;
	}
	
	for ( ii = 0; ii < nSizeStepsInCtrl; ii++ )
	{
		m_pXFWizCtrl->UpdateStep(ii, saXFLabels[ii]);
		m_pXFWizCtrl->ShowStep(ii, TRUE);
	}
	
	for ( ii = nSizeStepsInCtrl; ii < nSizeSteps; ii++ )
	{
		m_pXFWizCtrl->AddStep(saXFLabels[ii]);
		// control bug
		if ( 0 == ii )
			m_pXFWizCtrl->UpdateStep(ii, saXFLabels[ii]);
	}
	
	return true;
}
/*
bool XFWizRunModelDlg::GetStepLabels(const StringArray& saXFNames, StringArray& saXFLables)
{
	saXFLables = saXFNames;
	for ( int ii = 0; ii < saXFNames.GetSize(); ii++ )
	{
		int nIndex = m_saMapXFNames.Find(saXFNames[ii]);
		if ( nIndex >= 0 )
		{
			if ( nIndex > m_saMapXFNames.GetSize() - 1 || nIndex > m_saMapXFLabels.GetSize() - 1)
				return false;
		
			saXFLables[ii] = m_saMapXFLabels[nIndex];
		}
	}
	
	return true;
}
*/

void XFWizRunModelDlg::SetWizCtrlEventHandler(ClassObject m_objEventHandler)
{
	m_objWizCtrlEventHandler = m_objEventHandler;
}
//virtual
bool XFWizRunModelDlg::ActiveStep(int nStep)
{
	bool bRet;
	//pXFWizCtrl->SetEventHandler(NULL);
	ClassObject objEventHandlerJunk;
	m_pXFWizCtrl->SetEventHandler(objEventHandlerJunk);
	bRet = ( m_pXFWizCtrl->SetActiveStep(nStep) == nStep );
	m_pXFWizCtrl->SetEventHandler(m_objWizCtrlEventHandler);
	
	return bRet;
}

//virtual
void XFWizRunModelDlg::SetPageEventLink(bool bTurnOn)
{
	SendDlgMsg(WM_USER_WIZ_DLG_PAGE_EVENT_LINK, bTurnOn);
}

//virtual
bool XFWizRunModelDlg::OnAfterLoadXF()
{
	return SendDlgMsg(WM_USER_WIZ_DLG_AFTER_LOAD_XF);
}

//virtual
bool XFWizRunModelDlg::OnUndoXF()
{
	return SendDlgMsg(WM_USER_WIZ_DLG_UNDO_XF);
}

//virtual
void XFWizRunModelDlg::Close(int nModalRet)// = -1
{
	// WM_CLOSE will invoke OnCancel, but Dialog::Close() will not
	//PostDlgMsg(WM_CLOSE);
	PostDlgMsg(WM_USER_WIZ_DLG_CLOSE, nModalRet);
}


XFWizRunModelChangeParam::XFWizRunModelChangeParam(HWND hDlg, WizardControl *pWizCtrl)
: XFWizRunModelDlg(hDlg, pWizCtrl)
{
	m_stXFMode.dwXFMode = XF_WIZ_DIALOG_MODE|LTXF_CHANGE_PARAM;
	m_stXFMode.dwExecute = LTXF_EXECUTE|LTXF_FROM_AUTO_UPDATE;
}


/*
//XFWizDlg(XFCore *pXFCore);
XFWizDlg::XFWizDlg()
:XFDynaDlg(IDD_XF_WIZ_DLG, NULL, "ODlg8")
{
	m_nDlgType = XF_DLG_TYPE_WIZ;
	
	XFCore *pXFCore = CreateXFCore();
	ASSERT(pXFCore);
	pXFCore->SetXFMode(XF_WIZ_DIALOG_MODE);
	pXFCore->SetExecute(LTXF_EXECUTE);
	pXFCore->SetRecalculate(XFGETN_EX_NONE);
	pXFCore->SetResultsLogOutput(XFGETN_EX_NONE);
	
	m_pXFWizTheme = CreateXFWizTheme();
	ASSERT(m_pXFWizTheme);
	m_pXFWizTheme->SetClassName(pXFCore->GetClassName());
	m_pXFWizTheme->SetVersion(pXFCore->GetVersion());
	
	m_pXFWizIO = CreateXFWizInputOutputRange();
	ASSERT(m_pXFWizIO);
	
	m_pXFWizDlgNavg = new XFWizDlgNavigation(pXFCore);
	ASSERT(m_pXFWizDlgNavg);
	
	// for convert value between (Class*) and DWORD
	//m_pXFWizCtrl = new XFWizControl;
	m_pXFWizCtrl = new WizardControl;
	ASSERT(m_pXFWizCtrl);
}
XFWizDlg::~XFWizDlg()
{
	XFCore *pXFCore = m_pXFWizDlgNavg->GetXFCore();
	
	delete pXFCore; // This dialog is modeless. The XFCore object was created outside and passed into here.
	delete m_pXFWizTheme;
	delete m_pXFWizIO;
	delete m_pXFWizDlgNavg;
	delete m_pXFWizCtrl;
}
*/
XFWizDlg::XFWizDlg(XFWizManager *pXFWizManager)
:XFDynaDlg(IDD_XF_WIZ_DLG, NULL, "ODlg8")
{
	m_pXFWizManager = pXFWizManager;
	ASSERT(m_pXFWizManager);
	
	//m_pXFWizNavg = (XFWizNavigation *)(pXFWizManager->GetNavigation());
	//ASSERT(m_pXFWizNavg);
	
	// for convert value between (Class*) and DWORD
	//m_pXFWizCtrl = new WizardControl;
	//ASSERT(m_pXFWizCtrl);
	
	//if ( IsChangeParam() )
		//m_pXFWizRM = new XFWizRunModelDlg;
	//else
		//m_pXFWizRM = new XFWizRunModelChangeParam;
	//ASSERT(m_pXFWizRM);
	///---Sim 12-08-2008 FIX_RESET_DEFAULT_THEME_POPUP_ERR
	m_bGroupTheme = true;
	///---END FIX_RESET_DEFAULT_THEME_POPUP_ERR
	///---Sim 12-09-2008 QA80-12741 OPERATION_UNPROTECT_IO_RANGE_IN_EXEC_TIME_OF_CHANGE_PARAM_FUNC
	m_bDeleteOnDestroy = false;
	///---END QA80-12741 OPERATION_UNPROTECT_IO_RANGE_IN_EXEC_TIME_OF_CHANGE_PARAM_FUNC
}
XFWizDlg::~XFWizDlg()
{
	delete m_pXFWizManager; // modeless dialog hold outside pointer
	delete m_pXFWizRM;
}

//virtual bool XFWizDlg::CreatePreview(Page& pg)
//{
	//return true;
//}

//void XFWizDlg::Constructor()
//{
	//
//}

////virtual
//XFCore* XFWizDlg::CreateXFCore()
//{
	//XFCore *p = new XFCore;
	//return p;
//}
////virtual
//XFWizTheme* XFWizDlg::CreateXFWizTheme()
//{
	//XFWizTheme *p = new XFWizTheme;
	//return p;
//}
////virtual
//XFWizInputOutputRange* XFWizDlg::CreateXFWizInputOutputRange()
//{
	//XFWizInputOutputRange *p = new XFWizInputOutputRange;
	//return p;
//}

//int XFWizDlg::UpdateOperation(DWORD dwUIDOp)
//{
	//XFCore* pXFCore = m_pXFWizDlgNavg->GetXFCore();
	//ASSERT(pXFCore);
	//string strFile, strFunc;
	//if ( pXFCore->GetOPEntry(strFile, strFunc) )
	//{
		////PFNDoWizOp pfn = GetDoWizOp();
		////PFNDoWizOp pfn = Project.FindFunction(STR_WIZ_OP_FUNC, STR_WIZ_OP_FILE);
		////if ( pfn )
		////{
			//m_pXFWizTheme->ClearRuntimeInfo();
			//m_pXFWizTheme->SetHookOperation();
			//Tree trTheme;
			//m_pXFWizTheme->GetTree(trTheme);
			//
			//Tree trIOs;
			//m_pXFWizIO->GetTree(trIOs);
			//
			////return pfn(dwUIDOp, trTheme, trIOs, strFile, strFunc);
			//return DoWizardOperation(dwUIDOp, trTheme, trIOs, strFile, strFunc);
		////}
	//}
	//return 0;
//}
//// This retrieves the function pointer which is used for initializing and updating operation.
//PFNDoWizOp XFWizDlg::GetDoWizOp()
//{
	//PFNDoWizOp	pfn = Project.FindFunction("DoWizardOperation", "Originlab\\WizOperation.cpp");
	//
	//return pfn;
//}
/*
BOOL XFWizDlg::Create(HWND hParent, const TreeNode& trThemes, const TreeNode& trInputsOutputs, DWORD dwUIDOp)  //=NULL, NULL, 0
{
	if ( trInputsOutputs && !trInputsOutputs.IsEmpty() )
		m_pXFWizIO->SetTree(trInputsOutputs);
	
	
	if ( trThemes && !trThemes.IsEmpty() )
		m_pXFWizTheme->SetTree(trThemes);
	
	Page pgTarget;
	if ( !m_pXFWizIO->GetTargetPage(pgTarget) )
	{
		pgTarget = Project.Pages();
	}
	if ( CreatePreview(pgTarget) )
		m_pXFWizIO->SetTargetPage(pgTarget);
	
	XFCore *pXFCore = m_pXFWizDlgNavg->GetXFCore();
	pXFCore->SetTargetPage(pgTarget);
	
	///---Sim 08-19-2008 QA80-12050 GET_GUI_GETN_TREE_FOR_CHANGE_PARAM_MODE
	if ( IsChangeParam() )
	{
		pXFCore->SetXFMode(XF_WIZ_DIALOG_MODE|LTXF_CHANGE_PARAM);
		pXFCore->SetExecute(LTXF_EXECUTE|LTXF_FROM_AUTO_UPDATE);
	}
	///---END QA80-12050 GET_GUI_GETN_TREE_FOR_CHANGE_PARAM_MODE
	
	m_dwUIDOp = dwUIDOp;
	
	InitMsgMap();
	return XFDynaDlg::Create(hParent, pgTarget);		
}
*/
///---Sim 12-09-2008 QA80-12741 OPERATION_UNPROTECT_IO_RANGE_IN_EXEC_TIME_OF_CHANGE_PARAM_FUNC
int XFWizDlg::DoModal(HWND hParent)
{
	Page pgTarget;
	PrepareTargetPage(pgTarget);
	///---Sim 12-09-2008 QA80-12741 OPERATION_UNPROTECT_IO_RANGE_IN_EXEC_TIME_OF_CHANGE_PARAM_FUNC
	m_bDeleteOnDestroy = false;
	///---END QA80-12741 OPERATION_UNPROTECT_IO_RANGE_IN_EXEC_TIME_OF_CHANGE_PARAM_FUNC
	
	InitMsgMap();
	return XFDynaDlg::DoModal(hParent, pgTarget);		
}
///---END QA80-12741 OPERATION_UNPROTECT_IO_RANGE_IN_EXEC_TIME_OF_CHANGE_PARAM_FUNC
BOOL XFWizDlg::Create(HWND hParent)
{
	Page pgTarget;
	///---Sim 12-09-2008 QA80-12741 OPERATION_UNPROTECT_IO_RANGE_IN_EXEC_TIME_OF_CHANGE_PARAM_FUNC
	/*
	//if ( !m_pXFWizManager->GetTargetPage(pgTarget) )
	if ( !XFWIZ_MANAGER_MAP_IORANGE_CALL(m_pXFWizManager, GetTargetPage(pgTarget)) )
	{
		pgTarget = Project.Pages();
	}
	if ( m_pXFWizManager->CreatePreview(pgTarget) )
		//m_pXFWizManager->SetTargetPage(pgTarget);
		XFWIZ_MANAGER_MAP_IORANGE_CALL(m_pXFWizManager, SetTargetPage(pgTarget));
	*/
	PrepareTargetPage(pgTarget);
	///---END QA80-12741 OPERATION_UNPROTECT_IO_RANGE_IN_EXEC_TIME_OF_CHANGE_PARAM_FUNC
	///---Sim 12-09-2008 QA80-12741 OPERATION_UNPROTECT_IO_RANGE_IN_EXEC_TIME_OF_CHANGE_PARAM_FUNC
	m_bDeleteOnDestroy = true;
	///---END QA80-12741 OPERATION_UNPROTECT_IO_RANGE_IN_EXEC_TIME_OF_CHANGE_PARAM_FUNC
	
	InitMsgMap();
	return XFDynaDlg::Create(hParent, pgTarget);		
}
///---Sim 12-09-2008 QA80-12741 OPERATION_UNPROTECT_IO_RANGE_IN_EXEC_TIME_OF_CHANGE_PARAM_FUNC
void XFWizDlg::PrepareTargetPage(Page &pgTarget)
{
	//if ( !m_pXFWizManager->GetTargetPage(pgTarget) )
	if ( !XFWIZ_MANAGER_MAP_IORANGE_CALL(m_pXFWizManager, GetTargetPage(pgTarget)) )
	{
		pgTarget = Project.Pages();
	}
	if ( m_pXFWizManager->CreatePreview(pgTarget) )
		//m_pXFWizManager->SetTargetPage(pgTarget);
		XFWIZ_MANAGER_MAP_IORANGE_CALL(m_pXFWizManager, SetTargetPage(pgTarget));
}
///---END QA80-12741 OPERATION_UNPROTECT_IO_RANGE_IN_EXEC_TIME_OF_CHANGE_PARAM_FUNC

//DWORD XFWizDlg::OnGetWizCtrl(uint wParam, uint lParam)
//{
	//return (DWORD)m_pXFWizCtrl;
//}

BOOL XFWizDlg::OnInitDialog()
{
	waitCursor junk;
	
	Text = m_pXFWizManager->GetRunDlgName();
	
	vector<string>  vstrTipsUpDown;
	vstrTipsUpDown.SetSize(2);
	vstrTipsUpDown[0] = _L("Show XF");
	vstrTipsUpDown[1] = _L("Hide XF");
	XFDynaDlg::OnInitDialog(IDC_WIZARD_CONTROL, IDC_SHOW_BOTTOM, IDC_GRID, vstrTipsUpDown, GetThemeGroupName(), IDC_SHOW_TOP, NULL, 300);
	
	if ( !InitXFDynaDlg(IDC_GRID) )
		return false;
	
	m_comboTheme	= GetItem(IDC_THEME_COMB);
	
	m_btnPrevious	= GetItem(IDC_BTN_PREVIOUS);
	m_btnNext		= GetItem(IDC_BTN_NEXT);
	m_btnFinish		= GetItem(IDC_BTN_FINISH);
			
	Control ctrlWiz = GetItem(IDC_WIZARD_CONTROL);
	HWND hWnd = ctrlWiz.GetSafeHwnd();
	if(hWnd)
		m_XFWizCtrl.CreateControl(hWnd);
	else
		ASSERT(FALSE);
	m_XFWizCtrl.SetEventHandler(this);
	
	if ( IsChangeParam() )
		m_pXFWizRM = new XFWizRunModelChangeParam(GetSafeHwnd(), &m_XFWizCtrl);
	else
		m_pXFWizRM = new XFWizRunModelDlg(GetSafeHwnd(), &m_XFWizCtrl);
	ASSERT(m_pXFWizRM);
	
	m_pXFWizRM->SetWizCtrlEventHandler(this);
	//StringArray saMapXFNames, saMapXFLabels;
	//if ( m_pXFWizManager->GetMapXFName(saMapXFNames, saMapXFLabels) )
		//m_pXFWizRM->SetMapStepLabels(saMapXFNames, saMapXFLabels);
		
	BitmapRadioButton btnSaveAs = GetItem(IDC_XF_THEME_SAVEAS);
	vector<string> vsTips;
	btnSaveAs.Init(1, IDB_DROP_DOWN_UP, 16, vsTips);
	
	return TRUE;
}

BOOL XFWizDlg::OnReady()
{		
	//SetInitReady();
	
	//initThemeTree(m_trCurThemes);		//------ Folger 02/27/08 QA80-11182 WIZARD_THEME_VERSION_MECHANISM
	/////---Sim 12-08-2008 FIX_OPEN_DEFAULT_THEME
	//if ( !IsChangeParam() )
		//// use <default> theme if existing
		//XFWIZ_MANAGER_MAP_THEME_CALL(m_pXFWizManager, Load(STR_DEFAULT));
	/////---END FIX_OPEN_DEFAULT_THEME
	
	//if ( m_strDefaultThemeName.IsEmpty() )
		//GetLastAppliedTheme(GetThemeGroupName());
	//else
		//SetThemeInfo(m_strDefaultThemeName, GetThemeGroupName());
	
	//m_bEnableXFUpdatePath = false;	// NOT allow xf gui update Path Control, prevent update Path Control twice. 
									// As later we will update path from theme file.

	m_pXFWizManager->InitWizard(m_pXFWizRM);
	//m_pXFWizManager->OnBegin();
	m_pXFWizManager->OnChangeStep(0);
	
	
	TreeNode trGetN = GetTree();
	
	//string strThemeFile;
	//if (tree_get_theme_file_name(m_trCurThemes, strThemeFile))
	//{
		//tree_set_theme_file_name(trGetN, strThemeFile);
		//OnChangeTheme(strThemeFile, trGetN);		//argument here means nothing
	//}
	string strThemeFile;
	//if ( m_pXFWizManager->IsFromFile(strThemeFile) )
	if ( XFWIZ_MANAGER_MAP_THEME_CALL(m_pXFWizManager, IsFromFile(strThemeFile)) )
		tree_set_theme_file_name(trGetN, strThemeFile);
	
	InitThemeControls(this, trGetN, IDC_THEME_COMB, IDC_STATIC_THEME, IDC_XF_THEME_SAVE, IDC_XF_THEME_SAVEAS);	
	
	//m_bEnableXFUpdatePath = true; // recover load theme file issue function screened off XF update Path Control
	
	SetInitReady();
	UpdateDlgShowShowTopPane();
	
	//page_set_xf_dynadlg_storage(m_pg, (int)GetSafeHwnd());
	//ShowDialog();
	
	///---Sim 12-12-2008 QA80-12764-P3 PA_MODAL_DIALOG_ALSO_FORCE_SET_SHOW_FLAG_AS_ON_PAGE_CHANGE_EVENT_NEED_IT
	Show();
	///---END QA80-12764-P3 PA_MODAL_DIALOG_ALSO_FORCE_SET_SHOW_FLAG_AS_ON_PAGE_CHANGE_EVENT_NEED_IT
	
	return true;
}
BOOL XFWizDlg::OnDestroy()
{
	SetPageEventLink(false);
	DestroyXFDynaDlg();
	//return XFDynaDlg::OnDestroy();
	bool bRet = XFDynaDlg::OnDestroy();
	///---Sim 08-21-2008 QA80-12054 CAN_NOT_DELETE_OWN_OBJECT_ON_BASE_CLASS
	//delete this;
	///---END QA80-12054 CAN_NOT_DELETE_OWN_OBJECT_ON_BASE_CLASS
	
	////------ Folger 11/13/08 QA80-12488 v8.970 PROPER_HANDING_ABOUT_WIZARD_OPERATION_EXECUTE_HELPER
	//DestroyWizardOperationExecuteHelper(m_dwUIDOp);
	////------
	
	
	///---Sim 12-09-2008 QA80-12741 OPERATION_UNPROTECT_IO_RANGE_IN_EXEC_TIME_OF_CHANGE_PARAM_FUNC
	if ( m_bDeleteOnDestroy )
	///---END QA80-12741 OPERATION_UNPROTECT_IO_RANGE_IN_EXEC_TIME_OF_CHANGE_PARAM_FUNC
	delete this; // this dialog is only one for all wizard dialog, so don't care of QA80-12054
	return bRet;
}

//virtual
void XFWizDlg::InvokeHandlerOnDestroy()
{
	m_pXFWizManager->Destroy();
}

void XFWizDlg::updateNavigationButton()
{
	//m_btnPrevious.Enable = (m_pXFWizManager->GetStep() > 0);
	//m_btnNext.Enable = (m_pXFWizManager->GetStep() < m_pXFWizManager->GetNumSteps() - 1);
	int nStep = XFWIZ_MANAGER_MAP_NAVG_CALL(m_pXFWizManager, GetStep());
	int nNumSteps = XFWIZ_MANAGER_MAP_NAVG_CALL(m_pXFWizManager, GetNumSteps());
	m_btnPrevious.Enable = ( nStep > 0 );
	m_btnNext.Enable = ( nStep < nNumSteps - 1 );
	m_btnFinish.Enable = true;
}
void XFWizDlg::disableGoNextButton()
{
	m_btnNext.Enable = false;
	m_btnFinish.Enable = false;
}

//virtual
void XFWizDlg::OnEnableButtons(DWORD dwEnable, int nEventID)
{
	XFDynaDlg::OnEnableButtons(dwEnable, nEventID);
	
	updateNavigationButton();
	
	if ( !IsFrameworkNormal() )
		disableGoNextButton();
}

BOOL XFWizDlg::OnDlgResize(int nType, int cx, int cy)
{
	if(!IsInitReady())
		return TRUE;
	//doing...
	MoveControlsHelper	_temp(this);
	_temp.Exclude(IDC_GRID);
	_temp.Exclude(IDC_WIZARD_CONTROL); ///---Sim 11-28-2007 QA80-10721-P2 FIX_REDRAW_PATH_CONTROL
	/////---Sim 11-28-2007 FIX_UPDATE_WIZ_BTN
	//// these button will may be disable after path control changed
	//_temp.Exclude(IDCANCEL);
	//_temp.Exclude(IDC_BTN_FINISH);
	//_temp.Exclude(IDC_BTN_NEXT);
	//_temp.Exclude(IDC_BTN_PREVIOUS);
	/////---END FIX_UPDATE_WIZ_BTN
	uint nButtonIDs[] = {IDCANCEL, IDC_BTN_FINISH, IDC_BTN_NEXT, IDC_BTN_PREVIOUS, 0};
	MultiPaneDlg::OnDlgResize(nButtonIDs, cx, cy, false, GetControlGap(), SPACE_BETWEEN_EACH_BTN_GROUP);
	
	//------ Folger 12/03/07 COMPULSIVE_REFRESH_BUTTON_ENABLE_STATUS
	//code below just for refresh button enable status
	//m_btnPrevious.Text = _L("Prev");
	//m_btnNext.Text = _L("Next");
	//just set text again to refresh main buttons, without this refresh main buttons will fail under some conditions
	//------ just hide and show dialog to force refresh, no need refresh main buttons any more
	//mainButtonForceUpdate();
	//if ( !m_bXFScriptMode )		//hard code
	{
		if (nType == 1)		//if nType == 1, force dialog to refresh
		{
			Visible = false;
			Visible = true;
		}
	}
	//------
	
	//four lines must be here for top and bottom resize, don't know why
	if (cy != 0)
	{
		SetInitReady(false);
		UpdateDlgSizeShowTopPane();
		UpdateDlgSize();
		SetInitReady();
		
		updatePaneSize();
	}
	
	return true;
}
void XFWizDlg::updatePaneSize()
{
	updateTopPaneSize();
	updateBottomPaneSize();
}
bool XFWizDlg::updateBottomPaneSize()
{
	
	uint nControlIDs[] = {IDC_GRID,
						IDC_XF_NAME, IDC_DESCRIPTION, IDC_ERR_MESSAGE_BOX,
						//IDC_APPLY, IDC_UNDO_BTN, IDC_CHK_XFBAR_AUTO_APPLY,
						//IDC_GETN_CUSTOM_BTN1, IDC_GETN_CUSTOM_BTN2, IDC_GETN_CUSTOM_BTN3, IDC_GETN_CUSTOM_BTN4,
						0};
	
	if (IsBottomPaneShown())
	{
		ShowControls(nControlIDs, true);
				
		int nGap = GetControlGap();
		Control ctrlXFGrid;
		RECT	rrXFGrid;
		GetControlClientRect(IDC_GRID, rrXFGrid, ctrlXFGrid);
		
		m_rectXFDyna = rrXFGrid;
		return Resize(rrXFGrid);
	}
	else
	{
		ShowControls(nControlIDs, false);
		//------ Folger 12/10/07 REPOSITION_BUTTONS_WHEN_BOTTOM_PANE_HIDE
		//if bottom pane is hidden, just move buttons out of dialog
		RECT rr;
		m_wndDlg.GetClientRect(&rr);
		uint nControlIDs[] = {IDC_APPLY, IDC_UNDO_BTN, IDC_CHK_XFBAR_AUTO_APPLY, IDC_GETN_CUSTOM_BTN1, IDC_GETN_CUSTOM_BTN2, IDC_GETN_CUSTOM_BTN3, IDC_GETN_CUSTOM_BTN4, 0};
		ArrangeControlsLeftRight(nControlIDs, rr.left, rr.bottom + 2 * GetControlGap());
		//------
	}
	
	return true;
}

bool XFWizDlg::updateTopPaneSize()
{
	vector<uint> nControlIDs = {IDC_WIZARD_CONTROL, IDC_STATIC_THEME, IDC_THEME_COMB, IDC_XF_THEME_SAVEAS, 0};
	
	if (IsTopPaneShown())
	{
		ShowControls(nControlIDs, true);
		vector<uint> vsThemeBtnIDs;
		vsThemeBtnIDs = nControlIDs;
		vsThemeBtnIDs.RemoveAt(0);
		if ( !IsThemeDialog() )
			ShowControls(vsThemeBtnIDs, false);
			
		
		int nGap = GetControlGap();
		Control ctrlWizard;
		RECT	rrWizard;
		GetControlClientRect(IDC_WIZARD_CONTROL, rrWizard, ctrlWizard);
		
		///------ Folger 10/25/2010 ORG-1279 DIALOG_DISPLAY_NOT_GOOD_IN_CHINESE
		CheckResizeThemeLabel(IDC_STATIC_THEME);
		///------ End DIALOG_DISPLAY_NOT_GOOD_IN_CHINESE
		int ny = ArrangeControlsLeftRight(vsThemeBtnIDs, rrWizard.left, rrWizard.top, rrWizard.right, IDC_THEME_COMB);
		
		rrWizard.top = ny + nGap;
		MoveControl(ctrlWizard, rrWizard);
		
	}
	else
	{
		ShowControls(nControlIDs, false);
	}
	return true;
}
	
BOOL XFWizDlg::OnRestoreSize(DWORD dwSizeInfo)
{
	void * p = (void*)dwSizeInfo;
	DLGSIZEINFO *pSz = (DLGSIZEINFO*)p;

	lstrcpyn(pSz->szDialogName, GetThemeGroupName(), MAXLINE);
			
	pSz->top = -1;
	pSz->left = - 1;
	pSz->width = 400;
	///---Sim 11-10-2008 FIX_DEFAULT_SHOW_ALL_PA_XFS
	//pSz->height = 520;
	pSz->height = 600;
	///---END FIX_DEFAULT_SHOW_ALL_PA_XFS
	return TRUE;
}

//virtual
void XFWizDlg::ResizeDlgControls()
{
	Resize(m_rectXFDyna);
}
//virtual
void XFWizDlg::resizeDlgToFit(int cx, int cy)// = 0,0
{
	Resize(m_rectXFDyna);
}

BOOL XFWizDlg::OnShowBottomPane(Control ctrl)
{
	MultiPaneDlg::OnShowBottomPane(ctrl);
	updateBottomPaneSize();
	return true;
}

BOOL XFWizDlg::OnShowTopPane(Control ctrl)
{
	MultiPaneDlg::OnShowTopPane(ctrl);
	updatePaneSize();
	return true;
}

BOOL XFWizDlg::OnPrevious(Control ctrl)
{
	//return m_pXFWizManager->OnPrev();
	return XFWIZ_MANAGER_MAP_NAVG_CALL(m_pXFWizManager, OnPrev());
}
BOOL XFWizDlg::OnNext(Control ctrl)
{
	//return m_pXFWizManager->OnNext();
	return XFWIZ_MANAGER_MAP_NAVG_CALL(m_pXFWizManager, OnNext());
}

BOOL XFWizDlg::OnFinish(Control ctrl)
{
	////if ( !m_pXFWizDlgNavg->OnFinish() )
		////return false;
	////
	////UpdateOperation(m_dwUIDOp);
	//if ( !m_pXFWizManager->OnFinish() )
		//return false;
	//
	////Close();
	//return true;
	return XFWIZ_MANAGER_MAP_CALL(m_pXFWizManager, OnFinish());
}
BOOL XFWizDlg::OnCancel(Control ctrl)
{
	//if ( !m_pXFWizManager->OnCancel() )
		//return false;
	//
	/////---Sim 08-21-2008 QA80-12054 CANCEL_HANDLER_ALREADY_DESTROY_WINDOW
	////Close();
	/////---END QA80-12054 CANCEL_HANDLER_ALREADY_DESTROY_WINDOW
	//return true;
	//------ Folger 12/10/08 v8.0984d REMOVE_ANALYSIS_MARKER_WHEN_CLICK_CANCEL_IN_WIZARD
	//return XFWIZ_MANAGER_MAP_NAVG_CALL(m_pXFWizManager, OnCancel());
	return XFWIZ_MANAGER_MAP_CALL(m_pXFWizManager, OnCancel());
	//------
}

BOOL XFWizDlg::OnAfterLoadXF(uint wParam, uint lParam)
{
	OnSetGetN(GetTree()); ///---Sim 01-08-2008 QA80-12900 FIX_NOT_AUTO_CLEAR_FOR_XF_WIZ
	
	//XFCore* pXFCore = m_pXFWizDlgNavg->GetXFCore();
	//ASSERT(pXFCore);
	//
	//PEVENT_GETN pfnEvent = (PEVENT_GETN)(pXFCore->GetEventHandler());
	//PEVENT_GETN pfnEvent = (PEVENT_GETN)(m_pXFWizManager->GetEventHandler());
	PEVENT_GETN pfnEvent = (PEVENT_GETN)(XFWIZ_MANAGER_MAP_CORE_CALL(m_pXFWizManager, GetEventHandler()));
	SetEventCallback(NULL, pfnEvent);
	
	//UpdateXFDlg(m_rectXFDyna);
	UpdateXFDlg();
	
	return UpdateDynaControl(true, GETNEVENT_ON_INIT, true);
}

//BOOL  XFWizDlg::OnApplyXF(uint wParam, uint lParam)
//{
	//return XFDynaDlg::Apply();
//}
BOOL  XFWizDlg::OnUndoXF(uint wParam, uint lParam)
{
	return XFDynaDlg::Undo();
}
//BOOL  XFWizDlg::OnFinishXF(uint wParam, uint lParam)
//{
	//Control ctrl = GetItem(IDC_BTN_FINISH);
	//return OnFinish(ctrl);
//}

BOOL  XFWizDlg::OnSetPageEventLink(uint wParam, uint lParam)
{
	bool bTurnOn = (bool)wParam;
	SetPageEventLink(bTurnOn);
	return true;
}

BOOL XFWizDlg::OnClose(uint wParam, uint lParam)
{
	// WM_CLOSE will invoke OnCancel, but Close() will not
	int nModalRet = wParam;
	Close(nModalRet);
	return true;
}

/// Hong 09/24/09 QA80-14350 NLFIT_DLG_NEED_HINT_TO_GUIDE_USER_MAKE_IT_MODALLESS
BOOL XFWizDlg::OnClickOutside(DWORD wParam, DWORD lParam)
{
	if ( !m_bDeleteOnDestroy && 0 != wParam ) // modalless mode, UID not ZERO, user click on page
	{
		OptionalMessage("NLFitMinimizeToModalless", MB_OK);
	}
	return FALSE;
}
/// end NLFIT_DLG_NEED_HINT_TO_GUIDE_USER_MAKE_IT_MODALLESS

///Jasmine 04/14/10 QA81-15304 ANNOUNCE_FITTING_FUNC_CHANGE
BOOL XFWizDlg::OnFittingFuncChange(uint wParam, uint lParam)
{
	OnExternalMessage(EXTERNAL_MSG_FO_CHANGE_FUNC, 0);
	return TRUE;
}
///End ANNOUNCE_FITTING_FUNC_CHANGE

//virtual
TreeNode XFWizDlg::GetTree(bool bEditTree, bool bSkipFirstNode) // = true, true
{
	//TreeNode tr;
	//XFCore* pXFCore = m_pXFWizDlgNavg->GetXFCore();
	//ASSERT(pXFCore);
	//if ( pXFCore )
		//pXFCore->GetGetN(tr);
	//
	//return tr;
	return m_pXFWizManager->GetCurXFTree();
}
//virtual
string XFWizDlg::GetXFName(string& strXFDescription)// = NULL
{
	//string strXFName;
	//
	//XFCore* pXFCore = m_pXFWizDlgNavg->GetXFCore();
	//ASSERT(pXFCore);
	//if ( pXFCore )
		//strXFName = pXFCore->GetXFName(strXFDescription);
	//
	//if ( strXFName.IsEmpty() )
		//strXFName = m_pXFWizDlgNavg->GetXFName(m_pXFWizDlgNavg->GetStep());
		//
	//return strXFName;
	return m_pXFWizManager->GetCurXFName(strXFDescription);
}

string XFWizDlg::GetThemeGroupName()
{
	//XFCore* pXFCore = m_pXFWizDlgNavg->GetXFCore();
	//ASSERT(pXFCore);
	//if ( pXFCore )
		//return pXFCore->GetClassName();
	//
	//return NULL;
	return m_pXFWizManager->GetClassName();
}

bool XFWizDlg::IsThemeDialog()
{
#ifdef		_CHANGE_PARAMS_SUPPORT_LAODING_THEME_AND_COMPARING_THEME /// Hong 02/01/09 HIDE_THEME_CONTROL_IN_CHANGE_PARAMS_DLG_IN_SR5
	///Sophy 12/18/2008 v8.0988 QA80-12798 CHANGE_PARAMETERS_SHOULD_SHOW_THEME_MENU
	return true;
	///end CHANGE_PARAMETERS_SHOULD_SHOW_THEME_MENU
#endif		//_CHANGE_PARAMS_SUPPORT_LAODING_THEME_AND_COMPARING_THEME /// Hong 02/01/09 HIDE_THEME_CONTROL_IN_CHANGE_PARAMS_DLG_IN_SR5
	//return !(m_pXFWizManager->IsHookOperation());
	///------ Folger 11/03/09 BETTER_CHECKING_FOR_RUNNING_PA_FROM_AUTO_UPDATE
	//return !XFWIZ_MANAGER_MAP_THEME_CALL(m_pXFWizManager, IsHookOperation());
	return XFWIZ_MANAGER_MAP_CALL(m_pXFWizManager, IsHookOperation());
	///------ End BETTER_CHECKING_FOR_RUNNING_PA_FROM_AUTO_UPDATE
}
bool XFWizDlg::IsChangeParam()
{
	//return m_pXFWizManager->IsHookOperation();
	///------ Folger 11/03/09 BETTER_CHECKING_FOR_RUNNING_PA_FROM_AUTO_UPDATE
	//return XFWIZ_MANAGER_MAP_THEME_CALL(m_pXFWizManager, IsHookOperation());
	return XFWIZ_MANAGER_MAP_CALL(m_pXFWizManager, IsHookOperation());
	///------ End BETTER_CHECKING_FOR_RUNNING_PA_FROM_AUTO_UPDATE
}

//virtual
bool XFWizDlg::IsThemeLoadEnable()
{
	//return ( 0 == m_pXFWizManager->GetStep() );
	return ( 0 == XFWIZ_MANAGER_MAP_NAVG_CALL(m_pXFWizManager, GetStep()) );
}

//virtual
BOOL XFWizDlg::SaveTheme(TreeNode& trGetN, LPCSTR lpcszThemeName)
{
	if ( !m_pXFWizManager->SaveTheme(lpcszThemeName) )
	///Sophy 10/28/08 QA80-12442 SHOW_WARNING_WHEN_SAVE_READ_ONLY_FILE
	//	return false;
	{
		//if( m_pXFWizTheme )
			//popup_errmsg_save_readonly_file( m_pXFWizTheme->GetThemeFileName( lpcszThemeName ), m_hParent );
		popup_errmsg_save_readonly_file(XFWIZ_MANAGER_MAP_THEME_CALL(m_pXFWizManager, GetThemeFileName(lpcszThemeName)), NULL);
		return false;
	}
	///end SHOW_WARNING_WHEN_SAVE_READ_ONLY_FILE
	
	return true;
}

//virtual
BOOL XFWizDlg::LoadTheme(TreeNode& trGetN, LPCSTR lpcszThemeName)
{
	if ( !m_pXFWizManager->LoadTheme(lpcszThemeName) )
	{
		string strErr = "Failed to load ";
		if ( theme_is_factory_default(lpcszThemeName) )
			strErr += "factory default theme";
		else if ( is_theme_default(lpcszThemeName) )
			strErr += "<default> theme";
		else
			strErr += "theme " + XFWIZ_MANAGER_MAP_THEME_CALL(m_pXFWizManager, GetThemeFileName(lpcszThemeName));
		return error_report_to_user_and_developer(strErr);
	}
	
	return true;	
}

BOOL XFWizDlg::OnWizardStepActivate(int nIndexActivate, int nIndexDeactivate)
{
	//if ( nIndexActivate >= m_pXFWizCtrl->GetNumSteps() )
	//{
		//return SendMessage(WM_USER_WIZ_DLG_FINISH);
	//}
	
	//int nArrivedStep = ChangeStep(nIndexActivate, nIndexDeactivate);
	//int nArrivedStep = m_pXFWizDlgNavg->OnChangeStep(nIndexActivate);
	//if ( nArrivedStep != nIndexActivate )
	//{
		//if ( nArrivedStep != nIndexDeactivate )
			//SetActiveStep(nArrivedStep);
			//
		//return false;			
	//}
	//
	//return true;
	//return XFWIZ_MANAGER_MAP_NAVG_CALL(m_pXFWizManager, OnChangeStep(nIndexActivate));
	return m_pXFWizManager->OnChangeStep(nIndexActivate);
}
//bool XFWizDlg::SetActiveStep(int nStep)
//{
	//bool bRet;
	////pXFWizCtrl->SetEventHandler(NULL);
	//ClassObject objEventHandlerJunk;
	//m_pXFWizCtrl->SetEventHandler(objEventHandlerJunk);
	//bRet = ( m_pXFWizCtrl->SetActiveStep(nStep) == nStep );
	//m_pXFWizCtrl->SetEventHandler(this);
	//
	//return bRet;
//}

///---Sim 10-13-2008 NEW_PA_81_THEME_FILTER_SETTING
//virtual
BOOL XFWizDlg::IsShowThemeSetting()
{
	//return true;
	return XFWIZ_MANAGER_MAP_THEME_CALL(m_pXFWizManager, IsThemeSettingSupported());
}
//virtual
void XFWizDlg::ShowThemeSetting()
{
	ASSERT(IsShowThemeSetting());
	//Tree trThemeFilter;
	Tree tmp;
	TreeNode trThemeFilter = tmp.AddNode("trThemeFilter"); // Sim, fix runtime error, I don't know why it was broken for normal tree
	//if ( m_pXFWizTheme->GetThemeFilterTree(trThemeFilter) )
	if ( GetThemeFilterTree(trThemeFilter, NULL) )
	{
		//if ( GetNBox(trThemeFilter, _L("Peak Analyzer Theme Setting"), NULL, NULL, NULL, GetSafeHwnd()) )
		string strTitle = XFWIZ_MANAGER_MAP_THEME_CALL(m_pXFWizManager, GetThemeFilterDlgTitle());
		if ( GetNBox(trThemeFilter, strTitle, NULL, NULL, NULL, GetSafeHwnd()) )
		{
			//m_pXFWizTheme->SetThemeFilterTree(trThemeFilter);
			SetThemeFilterTree(trThemeFilter, NULL);
		}
	}
}

//virtual
bool XFWizDlg::GetThemeFilterTree(TreeNode& trThemeFilter, TreeNode& trGetN)
{
	if ( !trThemeFilter )
		return false;
	
	//if ( m_pXFWizTheme )
		//return m_pXFWizTheme->GetThemeFilterTree(trThemeFilter);
	
	//return false;
	return XFWIZ_MANAGER_MAP_THEME_CALL(m_pXFWizManager, GetThemeFilterTree(trThemeFilter));
}
//virtual
bool XFWizDlg::SetThemeFilterTree(TreeNode& trThemeFilter, TreeNode& trGetN)
{
	if ( !trThemeFilter )
		return false;
	
	//if ( m_pXFWizTheme )
		//return m_pXFWizTheme->SetThemeFilterTree(trThemeFilter);
	
	//return false;
	return XFWIZ_MANAGER_MAP_THEME_CALL(m_pXFWizManager, SetThemeFilterTree(trThemeFilter));
}
///---END NEW_PA_81_THEME_FILTER_SETTING

///---Sim 12-29-2008 QA80-12798 XF_WIZ_THEME_COMPARE
BOOL XFWizDlg::CompareTheme(const TreeNode& trGetN, LPCSTR lpcszThemeName, TreeNode& trDiff)
{
	return XFWIZ_MANAGER_MAP_CALL(m_pXFWizManager, CompareTheme(lpcszThemeName, trDiff));
}
///---END QA80-12798 XF_WIZ_THEME_COMPARE

///---Sim 01-07-2009 QA81-14898 SHOW_GUI_SETTINGS_FOR_XFWIZ_OPERATION
XFWizRunModelShowGUI::XFWizRunModelShowGUI()
{
	m_stXFMode.nXFType = XF_GETN_SIMPLE;
	m_stXFMode.dwXFMode = XF_WIZ_DIALOG_MODE;
	m_stXFMode.dwExecute = LTXF_NO_CALL;
	m_stXFMode.nAddRecalculate = XFGETN_EX_NONE;
	m_stXFMode.nAddResultsLogOutput = XFGETN_EX_NONE;
}

XFWizShowGUI::XFWizShowGUI(XFWizManager &xfwizManager)
{
	m_pXFWizManager = &xfwizManager;
	ASSERT(m_pXFWizManager);
}
XFWizShowGUI::~XFWizShowGUI()
{
	//delete m_pXFWizManager;
}

bool XFWizShowGUI::Show()
{
	Tree trGUI;
	
	int nStep, nNumSteps;
	m_pXFWizManager->InitWizard(&m_XFWizRM);
	do
	{
		XFWIZ_MANAGER_MAP_NAVG_CALL(m_pXFWizManager, OnNext());
		TreeNode tr = trGUI.AddNode(m_pXFWizManager->GetCurXFName());
		tr.Replace(m_pXFWizManager->GetCurXFTree(), true, true);
		tr.SetAttribute(STR_LABEL_ATTRIB, m_pXFWizManager->GetCurXFLabel());
		
		nStep = XFWIZ_MANAGER_MAP_NAVG_CALL(m_pXFWizManager, GetStep());
		nNumSteps = XFWIZ_MANAGER_MAP_NAVG_CALL(m_pXFWizManager, GetNumSteps());
	}while ( nStep < nNumSteps - 1 );
			
	if ( !GetNBox(trGUI, m_pXFWizManager->GetRunDlgName() + " "+ _L("Settings")) )
		return false;
	
	return true;
}
///---END QA81-14898 SHOW_GUI_SETTINGS_FOR_XFWIZ_OPERATION
